;*****************************************************************************
;* LEONID.ASM -- Alef Null DSP CARD 4 monitor interface                      *
;*							                     *
;* Here are equates for services provided by DSP CARD 4                      *
;* monitor.						                     *
;*							                     *
;* Copyright (C) 1992-1995 by Alef Null. All rights reserved.		     *
;* Author(s): Jarkko Vuori, OH2LNS			                     *
;* Modification(s):					                     *
;  EVM addresses  -- JBF				                     *
;  MICGAIN	  -- JBF 8/17/95			                     *
;  Disable/Enable interrupts in opencd -- JBF 2/27/96	                     *
;  Define different memory and clock crystals				     *
;*****************************************************************************
;*********************    I M P O R T A N T    *******************************
;*****************************************************************************
; As a user you must:
; 1).....Choose the card that you are using.,
; 2).....Select the clock frequency that you wish to use.
; 3).....Select the SCI baudrate you wish to use
;*****************************************************************************
;*********************   DO IT HERE AND ONLY HERE   **************************
;*****************************************************************************

EVM56K  equ 1           	;0 => DSPCARD4
                        	;1 => EVM56002 - standard
				;2 => EVM56002 - expanded

	if (EVM56K>0)
;-----------------------------------------------------------------------------
; Select EVM clock speed
; Some 66MHz parts will run up to 80 MHz
;-----------------------------------------------------------------------------
;xtal	equ	32000000 	; 32 MHz for most accurate SCI baudrates
;xtal	equ	40000000    	; 40 MHz for standard EVM
;xtal	equ	66000000	; 66 MHz for new EVM's !!!NOT DIVISIBLE BY 4!!!
xtal	equ	68000000	; 68 MHz experimental
;xtal	equ	80000000	; 80 MHz experimental
	endif

	if (EVM56K==0)
;-----------------------------------------------------------------------------
; Select DSP4 CARD clock speed
;-----------------------------------------------------------------------------
xtal	equ	27000000	; XTAL frq (in MHz)
;xtal	equ	29500000	
;xtal	equ	33000000
	endif

;----------------------------------------------------------------------------
; SCI parameters
; (Choose your default SCI baudrate)
;----------------------------------------------------------------------------
baud	equ	9600				    ; Testing
;baud	equ	19200				    ; SCI baud rate
;*****************************************************************************
;*****************************************************************************






;-----------------------------------------------------------------------------
; Start of the user program and data areas
;-----------------------------------------------------------------------------
user_code equ	$0040  	    	; user P-memory starting address
user_data equ	$0018		; use X- and Y-memories starting address

	if (EVM56K==2)		; EVMs allocate buffers differently
topmem	equ    $6800 		; upper memory used for booting
kiss_pars equ	topmem 		; and SCI buffers
buflen	equ	2048	  	; buffer size
	endif
	if (EVM56K==1)		; standard EVM
topmem equ	$1400
kiss_pars equ	topmem
buflen	equ	1024
	endif

;-----------------------------------------------------------------------------
; Macro for target system detecting (simulator or DSP CARD 4 platform)
;-----------------------------------------------------------------------------
system	macro	target
	if @scp("target",'simulator')!=0
sim_debug
	else
	    if @scp("target",'dsp4')==0
		fail "No such system: target, known systems are dsp4 or simulator"
	    endif
	endif
	endm

;-----------------------------------------------------------------------------
; Open serial communication port (reset all buffers)
;   a - kiss command routine address (zero if not is kiss mode)
;   b - xmit on/off routine address
;-----------------------------------------------------------------------------
opensc	macro
	jsr	<$0020
	endm

;-----------------------------------------------------------------------------
; Put a byte in x0 to the serial output
;-----------------------------------------------------------------------------
putc	macro
	jsr	<$0022
	endm

;-----------------------------------------------------------------------------
; Request a character from the serial input
; waits until character given and returns it in x0
;-----------------------------------------------------------------------------
getc	macro
_gc1	wait
	jsr	<$0024
	jcs	_gc1
	endm

;-----------------------------------------------------------------------------
; Look if there are characters waiting at the serial input
; If specified, wait for a given time (in seconds)
; returns C if there are no data available
;	 NC if there are data, and received data is placed to x0
;-----------------------------------------------------------------------------
lookc	macro	time
	if time==0
	    jsr     <$0024
	else
	    move    #>@cvi(time*19200),x0   ; set timer
	    jsr     <$0034
_cwait	    wait
	    jsr     <$0024		    ; check if we have a character available
	    jcc     _cfnd
	    jset    #4,y:$0002,_cwait	    ; no, are we tired for waiting
	    ori     #$01,ccr		    ; yes, ensure that C condition is met
_cfnd	    nop
	endif
	endm

;-----------------------------------------------------------------------------
; Test if there are characters waiting at the serial input
; returns C if there are no data available
;	 NC if there are data available
;-----------------------------------------------------------------------------
tstc	macro
	jsr	<$0026
	endm

;-----------------------------------------------------------------------------
; Terminate KISS output frame
;-----------------------------------------------------------------------------
endc	macro
	jsr	<$0028
	endm

;-----------------------------------------------------------------------------
; Reject KISS output frame
;-----------------------------------------------------------------------------
rejc	macro
	jsr	<$002A
	endm

;-----------------------------------------------------------------------------
; put next bit in C to the host transmit queue
;-----------------------------------------------------------------------------
putbit	macro
	jsr	<$002C
	endm

;-----------------------------------------------------------------------------
; returns next bit to be sent in C
; returns Z if this is an end of the transmission
;-----------------------------------------------------------------------------
getbit	macro
	jsr	<$002E
	endm

;-----------------------------------------------------------------------------
; Open codec
; fs  is the desired sampling rate   (8,9.6,16,27.42857,32,48)
; hpf is the high-pass filter enable (NOHPF,HPF)
;-----------------------------------------------------------------------------
NOHPF	equ	$0000
HPF	equ	$8000
MICGAIN equ     $100000	 		; Disable 20 dB MIC gain
;;MICGAIN equ     $000000   		; Enable  20 dB MIC gain
opencd	macro	fs,hpf

	ori     #3,mr  ; disable interrupts ----JBF----

	if @def(sim_debug)==0
	    if fs==8
		move			    #>$000000|MICGAIN|hpf,x0
	    else
		if fs==9.6
		    move		    #>$003800|MICGAIN|hpf,x0
		else
		    if fs==16
			move		    #>$000800|MICGAIN|hpf,x0
		    else
			if fs==27.42857
			    move	    #>$001000|MICGAIN|hpf,x0
			else
			    if fs==32
				move	    #>$001800|MICGAIN|hpf,x0
			    else
				if fs==48
				    move    #>$003000|MICGAIN|hpf,x0
				else
				    fail "Illegal sampling rate: fs"
				endif
			    endif
			endif
		    endif
		endif
	    endif
	    jsr     <$0030
	endif

	andi	#$fc,mr       ; unmask interrupts ---JBF---

	endm

;-----------------------------------------------------------------------------
; Set codecs input and output settings
;-----------------------------------------------------------------------------
HEADP	equ	$8000
LINEO	equ	$4000
SPEAKER equ	$0040

LINEI	equ	$0000
MIC	equ	$1000

ctrlcd	macro	init,reg,len,inputs,lgain,rgain,outputs,loattn,roattn
	if @def(sim_debug)==0
	    if	    (lgain>22.5)|(rgain>22.5)|(loattn>94.5)|(roattn>94.5)
	    fail 'Illegal input gain or output attenuation'
	    endif
	    move		#(inputs|$f0|(@cvi(lgain/1.5)<<8)|@cvi(rgain/1.5))<<8,x0
	    clr     a		#(outputs|(@cvi(loattn/1.5)<<8)|@cvi(roattn/1.5))<<8,x1
	    move    (reg)+
	    do	    #len,_initcs
	    if	    init
	    move		a,y:(reg)+
	    move		a,y:(reg)+
	    else
	    move		(reg)+
	    move		(reg)+
	    endif
	    move		x1,y:(reg)+
	    move		x0,y:(reg)+
_initcs
	    move    (reg)-
	endif
	endm

;-----------------------------------------------------------------------------
; Close codec
;-----------------------------------------------------------------------------
closecd macro
	jsr	<$0032
	endm

;-----------------------------------------------------------------------------
; Put byte in x0 to output port
;-----------------------------------------------------------------------------
putio	macro
	jsr	<$0036
	endm

;-----------------------------------------------------------------------------
; Carrier on
;-----------------------------------------------------------------------------
caron	macro
	jsr	<$0038
	endm

;-----------------------------------------------------------------------------
; Carrier off
;-----------------------------------------------------------------------------
caroff	macro
	jsr	<$003A
	endm

;-----------------------------------------------------------------------------
; Wait for the given time (in seconds)
;-----------------------------------------------------------------------------
sleep	macro	time
	move		    #@cvi(time*19200.0),x0
	jsr	<$0034
_slp1	wait
	jset	#4,y:$0002,_slp1
	endm

;-----------------------------------------------------------------------------
; Macro for waiting specified amount of input data from the codec
;-----------------------------------------------------------------------------
waitblk macro	reg,buflen,blklen
	if @def(sim_debug)==0
_loop	    ; bset    #0,x:$ffe4
	    wait					; wait for a new sample to be received
	    ; bclr    #0,x:$ffe4
	    move		r7,a
	    move		reg,x0
	    sub     x0,a	#>blklen*4+2,x0
	    jmi     <_wrap
	    cmp     x0,a				; wp - rp > threshold
	    jlo     <_loop
	    jmp     <_ok
_wrap	    move		#>buflen*4,x1
	    add     x1,a				; buffer wraparound, rp - wp + lenght > threshold
	    cmp     x0,a
	    jlo     <_loop
_ok
	else
	    movep		x:$ffe0,x:(reg)
	endif
	endm
;-----------------------------------------------------------------------------
